//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
struct stComplex
{
//+----------------+
    private :
        double m_r, m_i;
//+----------------+
    public  :
//+----------------+
        stComplex(): m_r(0), m_i(0) {}
//+----------------+
        stComplex(double r): m_r(r), m_i(0) {}
//+----------------+
        stComplex(double r, double i): m_r(r), m_i(i) {}
//+----------------+
        stComplex operator+(const double arg)
        {
            return stComplex(m_r + arg, m_i);
        }
//+----------------+
        stComplex operator+=(const double arg)
        {
            return stComplex(m_r += arg, m_i);
        }
//+----------------+
        bool operator<(const double arg)
        {
            return (m_r < arg);
        }
//+----------------+
        bool operator>(const double arg)
        {
            return (m_r > arg);
        }
//+----------------+
        stComplex operator+(const stComplex &arg)
        {
            return stComplex(m_r + arg.m_r, m_i + arg.m_i);
        }
//+----------------+
        stComplex operator+=(const stComplex &arg)
        {
            return stComplex(m_r += arg.m_r, m_i += arg.m_i);
        }
//+----------------+
        bool operator<(const stComplex &arg)
        {
            return ((m_r < arg.m_r) ? true : (m_r > arg.m_r ? false : (m_i < arg.m_i)));
        }
//+----------------+
        bool operator>(const stComplex &arg)
        {
            return ((m_r > arg.m_r) ? true : (m_r < arg.m_r ? false : (m_i > arg.m_i)));
        }
//+----------------+
        stComplex Debug(uint arg)
        {
            PrintFormat("Debugging the line %d = %.02f %c %.02fi", arg, m_r, (m_i < 0 ? '-' : '+'), MathAbs(m_i));
            return this;
        }
//+----------------+
};
//+------------------------------------------------------------------+
void OnStart(void)
{
    stComplex   a(1, 3);
    int counter = 0;

    while (stComplex(5) > a)
    {
        a.Debug(__LINE__);
        a += 1;
        counter++;
        if (counter > 50) break;
    }

    a.Debug(__LINE__);
    Print("The counter value is: ", counter);
}
//+------------------------------------------------------------------+